//
//  GlyphsPathPlugin.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GlyphsToolDrawProtocol.h"
#import "GlyphsToolEventProtocol.h"
#import "GSGlyphViewControllerProtocol.h"
#import "GSToolPlugin.h"

@class GSLayer;
@class GSAnchor; 
@class GSSnaper;
@class GSGuideLine;
#import "GSHint.h"
@class GSAlignmentZone;



@interface GlyphsPathPlugin : GSToolPlugin <GlyphsToolDraw, GlyphsToolEvent, NSMenuDelegate, NSTextViewDelegate>  {
	//BOOL hasDragged;
	BOOL _dragging;
	NSPoint _draggStart;
	NSPoint _contextClickPosition;
	//NSPoint _lastDragPosition;
	NSUInteger dragModifierFlag;
	//GSLayer * shadowLayer;
	NSMutableArray * snappers;
	NSMutableArray * activeSnappers;
	NSImage * _toolBarIcon;
	//NSImage * _toolBarIconSelect;
	//NSTimer * delayAction;
	//NSRect auswahlRect;
	GSLayer * activeLayer;
	GSLayer * forgroundLayer;
	GSElement *grabbedElement;
	NSRect selectionBounds;
	NSRect shadowSelectionBounds;
	CGFloat _interfaceScale;
	IBOutlet NSView *__unsafe_unretained colorButtonsView;
	IBOutlet NSMatrix *__unsafe_unretained colorButtons;
	IBOutlet NSMenu *__unsafe_unretained contextMenu;
	BOOL _isCancel;
	GSElement * _activeElement;
	NSColor * _nodeSmoothColor;
	NSColor * _nodeCornerColor;
	NSColor * _handleColor;
	NSColor * _zonesColor;
	NSColor * _metricsColor;
}
//! The icon displayed in the toolbar.
@property (nonatomic, readonly) NSImage * toolBarIcon;
//! The icon displayed in the toolbar when the button is pressed.
//@property(readonly) NSImage * toolBarIconSelect;
@property (nonatomic) BOOL dragging;
@property (nonatomic) NSPoint draggStart;
//@property(copy) GSLayer * shadowLayer;
@property (nonatomic, assign) CGFloat interfaceScale;

- (BOOL) willSelectTempTool:(id) tempTool ;
- (void) willDeactivate ;

- (NSMenu*) defaultContextMenu ;
- (void) addMenuItemsForEvent:(NSEvent*) theEvent toMenu:(NSMenu*) theMenu ;

- (void)insertNewline:(id)sender ;
- (void) drawBackground;
- (void) drawLayer:(GSLayer *) Layer atPoint:(NSPoint) aPoint asActive:(BOOL) Active attributes:(NSDictionary*) Attributes ;
- (void) drawBegin:(GSNode *) node isSelected:(BOOL) sel atPoint:(NSPoint) Point ;
#ifdef DEBUG
- (void) drawHandlesForBounds:(NSRect) Bounds atPoint:(NSPoint) aPoint ;
#endif
- (void) drawHandle:(GSPath *) Path atIndex:(NSUInteger) Index isSelected:(BOOL) selected atPoint:(NSPoint) Point ;
- (NSRect) getHandleRect:(NSPoint) pt isSelected:(bool) selected atPoint:(NSPoint) Point ;

- (void) drawAnchor:(GSAnchor*) Anchor atPoint:(NSPoint) Point active: (BOOL) Active ;
- (void) drawGuideLine:(GSGuideLine*) GuideLine  atPoint:(NSPoint) aPoint active: (BOOL) Active global:(BOOL) Global ;
- (void) drawHint:(GSHint*) Hint  atPoint:(NSPoint) aPoint active: (BOOL) Active ;
- (void) drawAlignmentZone:(GSAlignmentZone*) Hint atPoint:(NSPoint) aPoint ;
- (void) drawShadowAccents:(GSLayer *) Layer atPoint:(NSPoint) Point ;

- (NSPoint) transformOrigin;
- (void) setTransformOrigin:(NSPoint) Origin;
#ifndef GLYPHS_VIEWER
- (NSPoint) snapAtPoint:(NSPoint) Point withModifier:(NSUInteger) modifierFlag ;
- (void) addSnapper:(GSSnaper*) Snapper ;
- (void) addSnapperWithPoint:(NSPoint) Point ;
- (void) addActiveSnapper:(GSSnaper*) Snapper ;
//- (void) addHoverPoint:(NSPoint) newPoint ;
- (IBAction) selectAll:(id) sender ;
- (IBAction) deselectAll:(id)sender;
#ifndef GLYPHS_LITE
- (void) autohintLayers:(NSArray *)Layers ;
#endif
//- (IBAction) selectNextKnob:(id)sender;
//- (IBAction) selectPreviousKnob:(id)sender;
- (void) delSelection ;
- (void) delselectionWithModifier:(NSUInteger) ModifierFlag ;
//- (void) clearBackground:(id) sender ;
- (void) selectionToBackground:(id) sender ;
- (IBAction) swapForgroundWithBackground:(id) sender ;
- (GSNode *) connectPathsWithNode:(GSNode*) moveNode andNode: (GSNode*) overNode ;
- (GSNode *) nodeAtPoint:(NSPoint) aPoint atLayer:(GSLayer* ) Layer excludeNode:(GSNode *) Exclude ;
- (GSElement*) elementAtPoint:(NSPoint) Loc atLayer:(GSLayer*)Layer ;
- (void) transformSelection: (NSAffineTransform*) Transform ;
- (void) moveSelectionWithPoint:(NSPoint) Point withModifier:(NSUInteger) modifierFlag ;
- (void) drawMetricsForLayer:(GSLayer*) Layer atPoint:(NSPoint)Point asActive:(BOOL) Active ;
//- (void) setSmooth:(GSNode*) Node withCenterNode:(GSNode*) CenterNode oppositeNode:(GSNode*) OppositeNode ;
//- (void) setLooked:(GSNode*) Node shadow:(GSNode *) ShadowNode withPoint:(NSPoint) aPoint ;
//- (void) setInterpolate:(GSNode*) Node shadow:(GSNode *) ShadowNode withPoint:(NSPoint) offset ;
- (void) editAnchorName:(GSAnchor*) Anchor ;
- (void) setInterpolate:(GSLayer*) Layer withPoint:(NSPoint) offset ;
//- (void) setSymmetric:(GSNode *) Node withPoint:(NSPoint) pt;
- (NSString*) selectionEPSDataFromDict: (NSDictionary*) selectedObjects;
- (IBAction) addComponent:(id) sender ;
- (IBAction) addAnchor:(id) sender ;
- (IBAction) addVHint:(id) sender ;
- (IBAction) addHHint:(id) sender ;
- (NSArray*) addHintsForNodes:(NSMutableArray *)Nodes toLayer:(GSLayer *)Layer vertical:(BOOL)Vertical type:(GSHintType) Type;
- (IBAction) addGuideline:(id) sender ;
- (void) reversePaths:(id) sender ;
- (IBAction) reverseContour:(id) sender ;
- (void) checkConnections: (id) sender ;
- (void) addExtrems: (id) sender ;
- (IBAction) alignPoints:(id) sender ;
- (IBAction) resetColor:(id) sender ;
- (IBAction) setColor:(id) sender ;
#endif
@end
